/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixData;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalAffix;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.rank.RankManager;

public class InfestedAffix
extends GoalAffix {
    public InfestedAffix() {
        super("infested", AffixCategory.OFFENSE);
    }

    @Override
    public void onInitialSpawn(IChampion champion) {
        AffixData.IntegerData buffer = AffixData.getData(champion, this.getIdentifier(), AffixData.IntegerData.class);
        buffer.num = Math.min(ChampionsConfig.infestedTotal, Math.max(1, (int)((double)champion.getLivingEntity().m_21233_() * ChampionsConfig.infestedPerHealth)));
        buffer.saveData();
    }

    @Override
    public float onHeal(IChampion champion, float amount, float newAmount) {
        if (newAmount > 0.0f && champion.getLivingEntity().m_21187_().nextFloat() < 0.5f) {
            AffixData.IntegerData buffer = AffixData.getData(champion, this.getIdentifier(), AffixData.IntegerData.class);
            buffer.num = Math.min(ChampionsConfig.infestedTotal, buffer.num + 2);
            buffer.saveData();
            return Math.max(0.0f, newAmount - 1.0f);
        }
        return newAmount;
    }

    @Override
    public boolean onDeath(IChampion champion, DamageSource source) {
        Level world;
        AffixData.IntegerData buffer = AffixData.getData(champion, this.getIdentifier(), AffixData.IntegerData.class);
        LivingEntity target = null;
        if (source.m_7640_() instanceof LivingEntity) {
            target = (LivingEntity)source.m_7640_();
        }
        if ((world = champion.getLivingEntity().m_183503_()) instanceof ServerLevel) {
            InfestedAffix.spawnParasites(champion.getLivingEntity(), buffer.num, target, (ServerLevel)world);
        }
        return true;
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new SpawnParasiteGoal((Mob)champion.getLivingEntity())));
    }

    @Override
    public boolean canApply(IChampion champion) {
        EntityType type = champion.getLivingEntity().m_6095_();
        return type != ChampionsConfig.infestedParasite && type != ChampionsConfig.infestedEnderParasite && super.canApply(champion);
    }

    private static void spawnParasites(LivingEntity livingEntity, int amount, @Nullable LivingEntity target, ServerLevel world) {
        boolean isEnder = livingEntity instanceof EnderMan || livingEntity instanceof Shulker || livingEntity instanceof Endermite || livingEntity instanceof EnderDragon;
        EntityType<?> type = isEnder ? ChampionsConfig.infestedEnderParasite : ChampionsConfig.infestedParasite;
        for (int i = 0; i < amount; ++i) {
            Entity entity = type.m_20655_(world, null, null, null, livingEntity.m_142538_(), MobSpawnType.MOB_SUMMONED, false, false);
            if (!(entity instanceof LivingEntity)) continue;
            ChampionCapability.getCapability(entity).ifPresent(champion -> champion.getServer().setRank(RankManager.getLowestRank()));
            livingEntity.m_183503_().m_7967_(entity);
            if (!(entity instanceof Mob)) continue;
            ((Monster)entity).m_21373_();
            ((Monster)entity).m_6703_(target);
            ((Monster)entity).m_6710_(target);
        }
    }

    private class SpawnParasiteGoal
    extends Goal {
        private final Mob mobEntity;
        private int attackTime;

        public SpawnParasiteGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public void m_8056_() {
            this.attackTime = ChampionsConfig.infestedInterval * 20;
        }

        public void m_8037_() {
            --this.attackTime;
            if (this.attackTime <= 0) {
                ChampionCapability.getCapability((LivingEntity)this.mobEntity).ifPresent(champion -> {
                    AffixData.IntegerData buffer = AffixData.getData(champion, InfestedAffix.this.getIdentifier(), AffixData.IntegerData.class);
                    if (buffer.num > 0 && this.mobEntity.f_19853_ instanceof ServerLevel) {
                        this.attackTime = ChampionsConfig.infestedInterval * 20 + this.mobEntity.m_21187_().nextInt(5) * 10;
                        int amount = ChampionsConfig.infestedAmount;
                        InfestedAffix.spawnParasites((LivingEntity)this.mobEntity, amount, this.mobEntity.m_5448_(), (ServerLevel)this.mobEntity.f_19853_);
                        buffer.num = Math.max(0, buffer.num - amount);
                        buffer.saveData();
                    }
                });
            }
        }

        public boolean m_8036_() {
            return BasicAffix.canTarget((LivingEntity)this.mobEntity, this.mobEntity.m_5448_(), true);
        }
    }
}

